//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
struct stComplex
{
//+----------------+
    private :
        double m_r, m_i;
//+----------------+
    public  :
//+----------------+
        stComplex(): m_r(0), m_i(0) {}
//+----------------+
        stComplex(double r, double i): m_r(r), m_i(i) {}
//+----------------+
        stComplex operator+(const stComplex &arg1)
        {
            return stComplex(m_r + arg1.m_r, m_i + arg1.m_i);
        }
//+----------------+
        stComplex operator+(const double arg2)
        {
            return stComplex(m_r + arg2, m_i);
        }
//+----------------+
        stComplex operator+=(const double arg2)
        {
            return stComplex(m_r += arg2, m_i);
        }
//+----------------+
        stComplex Debug(uint arg)
        {
            PrintFormat("Debugging the line %d = %.02f %c %.02fi", arg, m_r, (m_i < 0 ? '-' : '+'), MathAbs(m_i));
            return this;
        }
//+----------------+
};
//+------------------------------------------------------------------+
void OnStart(void)
{
    stComplex   a(2, 5),
                b(8, -3),
                c;

    c = (a + b).Debug(__LINE__);
    c.Debug(__LINE__);
    (c += 4).Debug(__LINE__);
    c = (b + 4).Debug(__LINE__);
    c.Debug(__LINE__);
}
//+------------------------------------------------------------------+